/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Bird
**
** DESCRIPTION:	Manages bird
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef BIRD_H
#define BIRD_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"
#include "ldwImage.h"
#include "../Effects/FloatingAnim.h"
#include "../Game/Isola.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Bird_c_iMaxBirds = 9;
const int Bird_c_iMaxSpawnAreas = 4;
const int Bird_c_iChanceOfBirdsSpawning = 8;
const int Bird_c_iMinBirdsToSpawn = 5;
const int Bird_c_iMaxBirdsToSpawn = 9;
const int Bird_c_iDefaultBirdAnimSpeed = 2;
const int Bird_c_iBirdFlappingFrames = 4;

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum EBirdState
{
	eBirdState_Away = 0,
	eBirdState_Standing,
	eBirdState_ReadyToFly,
	eBirdState_Flying,
};

enum EBirdAction
{
	eBirdAction_None = 0,
	eBirdAction_Hopping,
	eBirdAction_Pecking,

	eBirdAction_NumberOf
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CBird 
{
private:

	struct SInst
	{
		friend class CBird;

	private:
		
		//structure data
		ldwPoint	m_sPos;
		ldwPoint	m_sTarget;
		ldwPoint	m_sVel;
		bool		m_bIsActive;
		bool		m_bIsInFlock;
		int			m_iType;
		int			m_iAnimIndex;
		int			m_iCurrentFrame;
		int			m_iScale;
		EDirection	m_eDirection;
		EBirdState	m_eBirdState;
		EBirdAction	m_eBirdAction;
		int			m_iDisplacement;

		//structure methods
		public:		void AcquireTarget();
	};

	struct SSpawnArea
	{
		ldwRect		m_sRect;
	};

	//class data
	SInst			m_InstArray[Bird_c_iMaxBirds];
	ldwImageGrid *	m_pGreenBird;
	ldwImageGrid *	m_pBirdShadow;

	SSpawnArea		m_sSpawnArea[Bird_c_iMaxSpawnAreas];
	int				m_iNumSpawnAreas;
	
	//class methods
	//setup
	public:		CBird();
	public:		~CBird();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		void Reset();

	//process
	public:		void AddSpawnArea(const ldwRect sRect);
	public:		const bool Create(const ldwPoint sBirdPos, const bool bIsInFlock);
	public:		const bool CreateFlyby(const ldwPoint sBirdPos);
	public:		void Update();
	public:		void Draw() const;
	public:		void Draw(const int iBird) const;
	public:		const int ScareNearbyBirds(const ldwPoint sPos, const int iSearchRadius);
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CBird		Bird;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/
